#!/usr/bin/env python
"""
Oto najnowsze wiadomoci.
Teleprompter oparty na Raspberry Pi, test 2
"""
import time                     # Na potrzeby dodawania opnie
import random
import os, pygame, sys

pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Teleprompter, test 2.")
screenWidth = 980
screenHeight =610
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))
segments = 4
segment = 0 # Pocztkowy punkt
textHeight = screenHeight / segments
textSurface = [ pygame.Surface((screenWidth,textHeight)) for s in range(0,segments+1)]

# Definiowanie kolorw interfejsu uytkownika
cBackground =(0,0,0)
cText = (255,255,255)
scrollSize = 30
background.fill(cBackground) # Okrelanie koloru ta
font = pygame.font.Font(None, textHeight)
numberOfLines = 0
newsLines = list()

def main():
   print"Oto najnowsze wiadomoci"
   getNews()
   lines = 0
   while lines < numberOfLines :
         for i in range(segments, 0, -1): # Przestawianie pl z tekstem
             textSurface[i] = textSurface[i-1]  
         lines = setWords(lines,0)
         offset = 0
         while offset < textHeight: 
            checkForEvent()
            drawScreen(offset)
            offset += scrollSize
   time.sleep(3.0)
   terminate()
            
def getNews():  # Otwieranie plikw z wiadomociami
   global numberOfLines, newsLines  
   nfile = open("news.txt","r")
   for line in nfile.readlines():
        newsLines.append(line)
        numberOfLines +=1
   nfile.close()

def drawScreen(offset) : # Rysowanie na ekranie
    global segment
    screen.blit(background,[0,0]) # Okrelanie koloru ta
    for index in range(0,segments+1):
      segment +=1
      if(segment > segments): # Zerowanie numeru segmentu
         segment = 0
      drawWords(segment,offset)
    pygame.display.update()
 
def setWords(index,segment) :
        endOfLine = False
        margin = 30 # czna ilo wolnego miejsca po obu stronach
        words = newsLines[index].split() # Tworzenie tablicy sw na podstawie wiersza
        wordsAvailable = len(words)
        wordsToUse = 0
        wordsWidth = 0
        tryLine = ""
        while wordsWidth < screenWidth - margin and wordsAvailable >= wordsToUse + 1:
          tryLine = ""
          wordsToUse += 1
          for test in range(0, wordsToUse):
             tryLine = tryLine + words[test] + " "
          textSurface[segment] = font.render(tryLine, True, cText, cBackground )
          tryWidth = textSurface[segment].get_rect()         
          wordsWidth = tryWidth.right
          print tryLine ," -> ma ",wordsWidth," pikseli szerokoci"
        useLine = ""
        if  wordsWidth > screenWidth - margin : # Obsuguje koniec wiersza
            wordsToUse -= 1 # Usuwanie ostatniego sowa
        else :
            endOfLine = True
        for test in range(0, wordsToUse): # Tworzenie odpowiedniego wiersza
             useLine = useLine + words[test] + " "
        textSurface[segment] = font.render(useLine, True, cText, cBackground )
        print "Uywanie wiersza :- ", useLine
        print
        newsLines[index] = newsLines[index][len(useLine) :]
        if endOfLine : # Przejcie do nastpnego wiersza
           index += 1
        return index

def drawWords(index,offset) :
        textRect = textSurface[index].get_rect()
        textRect.centerx = screenWidth / 2
        textRect.top = screenHeight - (textHeight * index) - offset   
        screen.blit(textSurface[index], textRect)
        
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosimy czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    global scrollSize
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN :
        if event.key == pygame.K_ESCAPE :
            terminate()
        if event.key == pygame.K_DOWN :
           scrollSize -= 1
           if scrollSize == 0:
              scrollsize = 1
        if event.key == pygame.K_UP :
           scrollSize += 1
            
if __name__ == '__main__':
    main()   
